//
// Created by dave on 2012-06-07.
//

#import <Foundation/Foundation.h>

@class OPAddressValue;

@interface OPAddressFormat : NSObject

@property (nonatomic, readonly) NSString *displayFormat;
@property (nonatomic, readonly) NSString *editFormat;
@property (nonatomic, readonly) NSDictionary *keyboardSettings;
@property (nonatomic, readonly) NSString *placeholderStringForKey;

+ (OPAddressFormat *)addressFormatForCountryCode:(NSString *)countryCode;
+ (NSString *)localizedCountryForCode:(NSString *)countryCode;
+ (NSArray *)countryCodes;

- (NSString *)displayTextForAddressValue:(OPAddressValue *)value;

- (NSArray *)componentsForRow:(NSUInteger)row editMode:(BOOL)editMode;
- (NSUInteger)numberOfRows:(BOOL)editMode;

@end